<?php $parent=dirname($abs); ?>
<section class="panel">
  <div class="pathbox">
    <div class="crumbs"><?php echo breadcrumb($abs) ?></div>
    <div class="actions">
      <a class="btn" href="?p=<?php echo h($parent) ?>">Naik Folder</a>
      <a class="btn" href="?p=/">Root /</a>
    </div>
  </div>
  <div class="toolbar">
    <form method="get" class="row">
      <label>Loncat ke path:</label>
      <input type="text" name="p" value="<?php echo h($abs) ?>" placeholder="Masukkan path absolut…">
      <button class="btn primary" type="submit">Buka</button>
    </form>
    <form method="post" class="row" onsubmit="return confirm('Ekstrak ZIP?')">
      <?php csrf_field(); ?><input type="hidden" name="a" value="unzip"><input type="hidden" name="p" value="<?php echo h($abs) ?>">
      <label>UNZIP:</label>
      <input type="text" name="zipfile" placeholder="Nama/path file.zip">
      <input type="text" name="dest" placeholder="Folder tujuan (kosong=folder ini)">
      <button class="btn" type="submit">Unzip</button>
    </form>
  </div>
  <div class="toolbar">
    <form method="post" enctype="multipart/form-data" class="row">
      <?php csrf_field(); ?><input type="hidden" name="a" value="upload"><input type="hidden" name="p" value="<?php echo h($abs) ?>">
      <label>Upload ke folder ini:</label>
      <input type="file" name="files[]" multiple required>
      <label class="inline"><input type="checkbox" name="overwrite" value="1"> Timpa jika ada</label>
      <button class="btn primary" type="submit">Upload</button>
    </form>
    <form method="post" class="row" onsubmit="return confirm('Buat folder baru?')">
      <?php csrf_field(); ?><input type="hidden" name="a" value="mkdir"><input type="hidden" name="p" value="<?php echo h($abs) ?>">
      <label>Folder baru:</label>
      <input type="text" name="folder" placeholder="Nama folder" required>
      <button class="btn" type="submit">Buat</button>
    </form>
  </div>
  <?php if(!$canList): ?><div class="alert err">Folder tidak bisa dibuka (mungkin tidak ada izin baca).</div>
  <?php else: ?>
  <form method="post" onsubmit="return confirm('Buat ZIP dari item terpilih?')">
    <?php csrf_field(); ?><input type="hidden" name="a" value="zip"><input type="hidden" name="p" value="<?php echo h($abs) ?>">
    <div class="row"><label>Nama file ZIP:</label><input type="text" name="zipname" placeholder="mis. arsip.zip"><button class="btn" type="submit">Buat ZIP</button></div>
    <table class="tbl">
      <thead><tr><th style="width:32px"></th><th>Nama</th><th style="width:120px">Ukuran</th><th style="width:120px">Izin</th><th style="width:160px">Modifikasi</th><th style="width:320px">Aksi</th></tr></thead>
      <tbody>
        <?php foreach($listing['dirs'] as $d): ?>
        <tr>
          <td><input class="checkbox" type="checkbox" name="items[]" value="<?php echo h($d['path']) ?>"></td>
          <td><a class="btn" href="?p=<?php echo rawurlencode($d['path']) ?>">📁 <?php echo h($d['name']) ?></a><?php if(!$d['read']): ?><span class="badge" title="Tidak dapat dibaca">no-read</span><?php endif; ?><?php if(!$d['write']): ?><span class="badge" title="Tidak dapat ditulis">no-write</span><?php endif; ?></td>
          <td>-</td><td><span class="badge"><?php echo h($d['perm']) ?></span></td>
          <td><?php echo $d['mtime'] ? date('Y-m-d H:i:s',$d['mtime']) : '-' ?></td>
          <td class="actions">
            <form method="post" class="inline" onsubmit="return confirm('Hapus folder ini beserta isinya?')">
              <?php csrf_field(); ?><input type="hidden" name="a" value="delete"><input type="hidden" name="p" value="<?php echo h($abs) ?>"><input type="hidden" name="target" value="<?php echo h($d['path']) ?>">
              <button class="btn danger" type="submit">Hapus</button>
            </form>
            <button class="btn" onclick="renameItem('<?php echo h($d['path']) ?>','<?php echo h($d['name']) ?>')">Rename</button>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php foreach($listing['files'] as $f): ?>
        <tr>
          <td><input class="checkbox" type="checkbox" name="items[]" value="<?php echo h($f['path']) ?>"></td>
          <td><?php echo h($f['name']) ?></td>
          <td><?php echo format_bytes($f['size']) ?></td>
          <td><span class="badge"><?php echo h($f['perm']) ?></span></td>
          <td><?php echo $f['mtime'] ? date('Y-m-d H:i:s',$f['mtime']) : '-' ?></td>
          <td class="actions">
            <a class="btn" href="?a=download&file=<?php echo rawurlencode($f['path']) ?>">Download</a>
            <?php if($f['read'] && $f['size']<=MAX_EDIT_BYTES && is_text_file($f['path'])): ?>
              <a class="btn" href="?a=edit&file=<?php echo rawurlencode($f['path']) ?>">Edit</a>
            <?php else: ?><span class="small" title="Bukan teks/terlalu besar/tiada izin">—</span><?php endif; ?>
            <form method="post" class="inline" onsubmit="return confirm('Hapus file ini?')">
              <?php csrf_field(); ?><input type="hidden" name="a" value="delete"><input type="hidden" name="p" value="<?php echo h($abs) ?>"><input type="hidden" name="target" value="<?php echo h($f['path']) ?>">
              <button class="btn danger" type="submit">Hapus</button>
            </form>
            <button class="btn" onclick="renameItem('<?php echo h($f['path']) ?>','<?php echo h($f['name']) ?>')">Rename</button>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </form>
  <?php endif; ?>
</section>
<form id="frmRename" method="post" class="hidden">
  <?php csrf_field(); ?><input type="hidden" name="a" value="rename"><input type="hidden" name="p" value="<?php echo h($abs) ?>"><input type="hidden" name="old" id="rnOld"><input type="hidden" name="new" id="rnNew">
</form>
<script>
function renameItem(fullPath, baseName){
  var nm = prompt("Nama baru untuk:\n" + baseName, baseName);
  if (!nm) return;
  var newPath = fullPath.replace(/[^\/\\]+$/, nm);
  document.getElementById('rnOld').value = fullPath;
  document.getElementById('rnNew').value = newPath;
  document.getElementById('frmRename').submit();
}
</script>
