<?php
function safe_realpath($path){ $rp=@realpath($path); if($rp!==false)return $rp; if(str_starts_with($path,DIRECTORY_SEPARATOR))return $path; return rtrim(getcwd(),DIRECTORY_SEPARATOR).DIRECTORY_SEPARATOR.$path; }
function ensure_in_base($abs){ if(ALLOW_OUTSIDE_BASE)return $abs; $base=rtrim(BASE_PATH,DIRECTORY_SEPARATOR).DIRECTORY_SEPARATOR; $abs2=rtrim($abs,DIRECTORY_SEPARATOR).DIRECTORY_SEPARATOR; if(str_starts_with($abs2,$base))return $abs; return BASE_PATH; }
function perms_to_string($file){ $perms=@fileperms($file); if($perms===false)return '---------'; $t=($perms&0x4000)?'d':(($perms&0xA000)?'l':'-'); $map=array(0x0100=>'r',0x0080=>'w',0x0040=>'x',0x0020=>'r',0x0010=>'w',0x0008=>'x',0x0004=>'r',0x0002=>'w',0x0001=>'x'); $bits=''; foreach(array(0x0100,0x0080,0x0040,0x0020,0x0010,0x0008,0x0004,0x0002,0x0001) as $b){ $bits.=($perms&$b)?$map[$b]:'-'; } return $t.$bits; }
function is_text_file($path){ $ext=strtolower(pathinfo($path,PATHINFO_EXTENSION)); $TEXT_EXT=array('txt','md','log','csv','json','xml','yml','yaml','ini','conf','config','php','phps','phtml','html','htm','css','js','ts','tsx','jsx','sql','py','java','c','cpp','h','hpp','rb','go','rs','kt','sh','bat','ps1'); return in_array($ext,$TEXT_EXT,true); }
function fd_namecmp($a,$b){ return strcasecmp($a['name'],$b['name']); }
function list_dir($dir){ $out=array('dirs'=>array(),'files'=>array()); if(!is_dir($dir)||!is_readable($dir))return $out; $items=@scandir($dir); if($items===false)return $out; foreach($items as $it){ if($it==='.'||$it==='..')continue; $full=$dir.DIRECTORY_SEPARATOR.$it; $isDir=is_dir($full); $sz=0; if(!$isDir && is_readable($full)){ $fsz=@filesize($full); $sz=$fsz?$fsz:0; } $mt=@filemtime($full); if(!$mt)$mt=0; $rec=array('name'=>$it,'path'=>$full,'size'=>$isDir?0:$sz,'perm'=>perms_to_string($full),'read'=>is_readable($full),'write'=>is_writable($full),'mtime'=>$mt,'isdir'=>$isDir); if($isDir)$out['dirs'][]=$rec; else $out['files'][]=$rec; } usort($out['dirs'],'fd_namecmp'); usort($out['files'],'fd_namecmp'); return $out; }
function rrmdir($dir){ if(!is_dir($dir))return @unlink($dir); $items=@scandir($dir); if($items===false)return false; foreach($items as $it){ if($it==='.'||$it==='..')continue; $p=$dir.DIRECTORY_SEPARATOR.$it; if(is_dir($p)&&!is_link($p)){ if(!rrmdir($p))return false; } else { if(!@unlink($p))return false; } } return @rmdir($dir); }
function add_to_zip($zip,$path,$base){ if(is_dir($path)&&!is_link($path)){ $zip->addEmptyDir($base); $items=@scandir($path); if($items){ foreach($items as $it){ if($it==='.'||$it==='..')continue; add_to_zip($zip,$path.DIRECTORY_SEPARATOR.$it,$base.'/'.$it); } } } else { $zip->addFile($path,$base); } }
function ensure_zip_enabled(){ if(!class_exists('ZipArchive')){ http_response_code(500); exit('ZipArchive tidak tersedia. Aktifkan ekstensi php-zip.'); } }
function breadcrumb($abs){
  if(preg_match('~^[A-Za-z]:\\\\\\\~',$abs)){ $drive=substr($abs,0,2); $rest=substr($abs,2); $parts=explode(DIRECTORY_SEPARATOR,$rest); $chunks=array(); foreach($parts as $c){ if($c!=='')$chunks[]=$c; } $acc=$drive; $links=array(); $links[]='<a href="?p='.rawurlencode($acc.DIRECTORY_SEPARATOR).'">'.h($drive).'</a>'; foreach($chunks as $c){ $acc.=DIRECTORY_SEPARATOR.$c; $links[]='<a href="?p='.rawurlencode($acc).'">'.h($c).'</a>'; } return implode(' <span class="sep">›</span> ',$links); }
  $links=array('<a href="?p='.rawurlencode(DIRECTORY_SEPARATOR).'">/</a>'); $parts=explode(DIRECTORY_SEPARATOR,$abs); $chunks=array(); foreach($parts as $c){ if($c!=='')$chunks[]=$c; } $acc=''; foreach($chunks as $c){ $acc.=DIRECTORY_SEPARATOR.$c; $links[]='<a href="?p='.rawurlencode($acc).'">'.h($c).'</a>'; } return implode(' <span class="sep">›</span> ',$links);
}
